typedef unsigned char cfg_u8;
typedef union {
    struct {
        cfg_u8 offset;
        cfg_u8 value;
    };
    struct {
        cfg_u8 command;
        cfg_u8 param;
    };
} cfg_reg;

#define CFG_META_SWITCH (255)
#define CFG_META_DELAY  (254)
#define CFG_META_BURST  (253)

/* Example C code */
/*
    // Externally implemented function that can write n-bytes to the device
    // PCM51xx and TAS5766 targets require the high bit (0x80) of the I2C register to be set on multiple writes.
    // Refer to the device data sheet for more information.
    extern int i2c_write(unsigned char *data, int n);
    // Externally implemented function that delays execution by n milliseconds
    extern int delay(int n);
    // Example implementation.  Call like:
    //     transmit_registers(registers, sizeof(registers)/sizeof(registers[0]));
    void transmit_registers(cfg_reg *r, int n)
    {
        int i = 0;
        while (i < n) {
            switch (r[i].command) {
            case CFG_META_SWITCH:
                // Used in legacy applications.  Ignored here.
                break;
            case CFG_META_DELAY:
                delay(r[i].param);
                break;
            case CFG_META_BURST:
                i2c_write((unsigned char *)&r[i+1], r[i].param);
                i += (r[i].param + 1)/2;
                break;
            default:
                i2c_write((unsigned char *)&r[i], 2);
                break;
            }
            i++;
        }
    }
 */

cfg_reg registers[] = {
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Reset
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Reset
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// Set the device into Powerdown
    { 0x02, 0x11 },
// Reset Device
    { 0x01, 0x11 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Sleep
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Sleep
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// Mute Left and Right Channels
    { 0x03, 0x11 },
// Set the device into Standby
    { 0x02, 0x10 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: C-RAM Buffer A
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Begin C-RAM_D, Buffer A Dump
//-------------------------------------------------
// Coefficient Memory A
// page 44 (0x2C)
    { 0x00, 0x2C },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0xFF },
        { 0xFF, 0xFF },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x08 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x0B },
        { 0xC0, 0x00 },
        { 0x00, 0x29 },
        { 0x80, 0x00 },
        { 0x00, 0x00 },
        { 0x06, 0xD3 },
        { 0x00, 0x7F },
        { 0xF9, 0x2D },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0xE0 },
        { 0x00, 0x00 },
        { 0x00, 0x32 },
        { 0x00, 0x00 },
        { 0x00, 0x15 },
        { 0x38, 0xD7 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x44, 0x32 },
        { 0x00, 0x7F },
        { 0xBB, 0xCE },
        { 0x00, 0x00 },
        { 0x06, 0xD3 },
        { 0x00, 0x7F },
        { 0xF9, 0x2D },
        { 0x00, 0xDE },
        { 0x40, 0x00 },
        { 0x00, 0xEA },
        { 0xE1, 0x47 },
        { 0x00, 0x29 },
        { 0x40, 0x00 },
        { 0x00, 0x0B },
        { 0xC1, 0x16 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 45 (0x2D)
    { 0x00, 0x2D },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0xC2 },
        { 0x00, 0x00 },
        { 0x00, 0x35 },
        { 0x20, 0x00 },
        { 0x00, 0x18 },
        { 0x58, 0xD7 },
        { 0x00, 0xD7 },
        { 0x41, 0xA0 },
        { 0x00, 0xFF },
        { 0xF0, 0x00 },
        { 0x00, 0x88 },
        { 0x00, 0x00 },
        { 0x00, 0x18 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x30 },
        { 0x00, 0x00 },
        { 0x00, 0xD0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x03, 0x84 },
        { 0x00, 0x00 },
        { 0xB2, 0x55 },
        { 0x00, 0x0E },
        { 0x5B, 0xDE },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x02 },
        { 0x00, 0x00 },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x51, 0x26 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x0C, 0xDC },
        { 0x00, 0x02 },
        { 0x00, 0x00 },
        { 0x00, 0x02 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0xE0 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x7F, 0xF7 },
        { 0x00, 0x00 },
// page 46 (0x2E)
    { 0x00, 0x2E },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x08 },
        { 0x00, 0x00 },
        { 0x00, 0xE0 },
        { 0x00, 0x00 },
        { 0x00, 0xF8 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x50 },
        { 0x00, 0x00 },
        { 0x00, 0x14 },
        { 0x40, 0x00 },
        { 0x00, 0x1C },
        { 0xC0, 0x00 },
        { 0x00, 0x23 },
        { 0x00, 0x00 },
        { 0x00, 0x21 },
        { 0x80, 0x00 },
        { 0x00, 0x00 },
        { 0x38, 0xDA },
        { 0x00, 0x7F },
        { 0xC7, 0x26 },
        { 0x00, 0x05 },
        { 0xB7, 0xB1 },
        { 0x00, 0x00 },
        { 0x25, 0xE9 },
        { 0x00, 0x7F },
        { 0xDA, 0x17 },
        { 0x00, 0x00 },
        { 0x0C, 0xA4 },
        { 0x00, 0x7F },
        { 0xF3, 0x5C },
        { 0x00, 0x0C },
        { 0x6F, 0xD5 },
        { 0x00, 0x08 },
        { 0x00, 0x00 },
        { 0x00, 0x7C },
        { 0x71, 0x8A },
        { 0x00, 0x84 },
        { 0xB5, 0x61 },
        { 0x00, 0x7A },
        { 0x29, 0x1C },
        { 0x00, 0x7A },
        { 0xC4, 0xDE },
        { 0x00, 0x88 },
        { 0x59, 0xD8 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 47 (0x2F)
    { 0x00, 0x2F },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x3F, 0xFA },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0xE0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x7F, 0xFF },
        { 0x00, 0x08 },
        { 0x46, 0x34 },
        { 0x00, 0xF8 },
        { 0x08, 0x2F },
        { 0x00, 0x07 },
        { 0xAF, 0x06 },
        { 0x00, 0x7F },
        { 0x92, 0x09 },
        { 0x00, 0x80 },
        { 0xD6, 0x54 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x03 },
        { 0x9C, 0x65 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x80 },
        { 0x6D, 0xF8 },
        { 0x00, 0x7F },
        { 0x29, 0xAB },
        { 0x00, 0x7B },
        { 0x43, 0x5A },
        { 0x00, 0x89 },
        { 0x22, 0xB1 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x00 },
// page 48 (0x30)
    { 0x00, 0x30 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x7E },
        { 0x39, 0x00 },
        { 0x00, 0x83 },
        { 0x81, 0x89 },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x7E },
        { 0x39, 0x00 },
        { 0x00, 0x83 },
        { 0x81, 0x89 },
        { 0x00, 0x1E },
        { 0xF0, 0x7E },
        { 0x00, 0x7E },
        { 0x3C, 0x1E },
        { 0x00, 0x81 },
        { 0xC3, 0xE2 },
        { 0x00, 0x7E },
        { 0x3C, 0x1E },
        { 0x00, 0x7E },
        { 0x39, 0x00 },
        { 0x00, 0x83 },
        { 0x81, 0x89 },
        { 0x00, 0x7E },
        { 0x3C, 0x1E },
        { 0x00, 0x81 },
        { 0xC3, 0xE2 },
        { 0x00, 0x7E },
        { 0x3C, 0x1E },
        { 0x00, 0x7E },
        { 0x39, 0x00 },
        { 0x00, 0x83 },
        { 0x81, 0x89 },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x71 },
        { 0x34, 0xCC },
        { 0x00, 0x8E },
        { 0xCB, 0x34 },
        { 0x00, 0x71 },
        { 0x34, 0xCC },
        { 0x00, 0x70 },
        { 0xB8, 0xC0 },
        { 0x00, 0x9C },
        { 0x9E, 0x50 },
        { 0x00, 0x74 },
        { 0xB3, 0xDC },
        { 0x00, 0x8B },
        { 0x4C, 0x24 },
        { 0x00, 0x74 },
        { 0xB3, 0xDC },
        { 0x00, 0x74 },
        { 0x33, 0xFB },
        { 0x00, 0x95 },
        { 0x98, 0x85 },
        { 0x00, 0x00 },
// page 49 (0x31)
    { 0x00, 0x31 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0x3D, 0xF6 },
        { 0x00, 0x81 },
        { 0x2F, 0x59 },
        { 0x00, 0x7E },
        { 0x68, 0xE7 },
        { 0x00, 0x7E },
        { 0xD0, 0xA7 },
        { 0x00, 0x82 },
        { 0x59, 0x22 },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0xFF },
        { 0x80, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 50 (0x32)
    { 0x00, 0x32 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 51 (0x33)
    { 0x00, 0x33 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x04 },
        { 0x02, 0x30 },
        { 0x00, 0xEB },
        { 0x53, 0xCD },
        { 0x00, 0x3F },
        { 0x1F, 0x1E },
        { 0x00, 0x43 },
        { 0x00, 0x00 },
        { 0x00, 0x03 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x8E },
        { 0x7A, 0x54 },
        { 0x00, 0x76 },
        { 0xC3, 0xB6 },
        { 0x00, 0xBD },
        { 0x33, 0x8F },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x7B, 0xA7 },
        { 0x00, 0x00 },
        { 0x7B, 0xA7 },
        { 0x00, 0x00 },
        { 0x7B, 0xA7 },
        { 0x00, 0x70 },
        { 0x46, 0x2B },
        { 0x00, 0x9D },
        { 0x85, 0x0E },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
// page 52 (0x34)
    { 0x00, 0x34 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x0F },
        { 0x99, 0x4B },
        { 0x00, 0x5A },
        { 0x87, 0x2B },
        { 0x00, 0x2D },
        { 0x41, 0x3D },
        { 0x00, 0x5A },
        { 0x82, 0x7A },
        { 0x00, 0x00 },
        { 0x3E, 0x9B },
        { 0x00, 0xF8 },
        { 0x00, 0x00 },
        { 0x00, 0xFF },
        { 0x80, 0x00 },
        { 0x00, 0xFE },
        { 0x00, 0x00 },
        { 0x00, 0x64 },
        { 0x87, 0xED },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x47 },
        { 0xC0, 0x00 },
        { 0x00, 0x5A },
        { 0xC0, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0xFF },
        { 0xFF, 0xFF },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x08 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x0B },
        { 0xC0, 0x00 },
        { 0x00, 0x29 },
        { 0x80, 0x00 },
        { 0x00, 0x00 },
        { 0x06, 0xD3 },
        { 0x00, 0x7F },
        { 0xF9, 0x2D },
        { 0x00, 0x00 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: C-RAM Buffer B
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Begin C-RAM_D, Buffer B Dump
//-------------------------------------------------
// Coefficient Memory B
// page 62 (0x3E)
    { 0x00, 0x3E },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0xFF },
        { 0xFF, 0xFF },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x08 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x0B },
        { 0xC0, 0x00 },
        { 0x00, 0x29 },
        { 0x80, 0x00 },
        { 0x00, 0x00 },
        { 0x06, 0xD3 },
        { 0x00, 0x7F },
        { 0xF9, 0x2D },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0xE0 },
        { 0x00, 0x00 },
        { 0x00, 0x32 },
        { 0x00, 0x00 },
        { 0x00, 0x15 },
        { 0x38, 0xD7 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x44, 0x32 },
        { 0x00, 0x7F },
        { 0xBB, 0xCE },
        { 0x00, 0x00 },
        { 0x06, 0xD3 },
        { 0x00, 0x7F },
        { 0xF9, 0x2D },
        { 0x00, 0xDE },
        { 0x40, 0x00 },
        { 0x00, 0xEA },
        { 0xE1, 0x47 },
        { 0x00, 0x29 },
        { 0x40, 0x00 },
        { 0x00, 0x0B },
        { 0xC1, 0x16 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 63 (0x3F)
    { 0x00, 0x3F },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0xCC },
        { 0xE0, 0x00 },
        { 0x00, 0x35 },
        { 0x20, 0x00 },
        { 0x00, 0x1A },
        { 0x94, 0x25 },
        { 0x00, 0xD7 },
        { 0x41, 0xA0 },
        { 0x00, 0xFF },
        { 0xF0, 0x00 },
        { 0x00, 0x88 },
        { 0x00, 0x00 },
        { 0x00, 0x18 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x30 },
        { 0x00, 0x00 },
        { 0x00, 0xD0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x03, 0x84 },
        { 0x00, 0x00 },
        { 0xB2, 0x55 },
        { 0x00, 0x0E },
        { 0x5B, 0xDE },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x02 },
        { 0x00, 0x00 },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x51, 0x26 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x0C, 0xDC },
        { 0x00, 0x02 },
        { 0x00, 0x00 },
        { 0x00, 0x02 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0xE0 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x7F, 0xF7 },
        { 0x00, 0x00 },
// page 64 (0x40)
    { 0x00, 0x40 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x08 },
        { 0x00, 0x00 },
        { 0x00, 0xE0 },
        { 0x00, 0x00 },
        { 0x00, 0xF8 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x50 },
        { 0x00, 0x00 },
        { 0x00, 0x14 },
        { 0x40, 0x00 },
        { 0x00, 0x1C },
        { 0xC0, 0x00 },
        { 0x00, 0x23 },
        { 0x00, 0x00 },
        { 0x00, 0x21 },
        { 0x80, 0x00 },
        { 0x00, 0x00 },
        { 0x38, 0xDA },
        { 0x00, 0x7F },
        { 0xC7, 0x26 },
        { 0x00, 0x05 },
        { 0xB7, 0xB1 },
        { 0x00, 0x00 },
        { 0x25, 0xE9 },
        { 0x00, 0x7F },
        { 0xDA, 0x17 },
        { 0x00, 0x00 },
        { 0x0C, 0xA4 },
        { 0x00, 0x7F },
        { 0xF3, 0x5C },
        { 0x00, 0x0C },
        { 0x6F, 0xD5 },
        { 0x00, 0x08 },
        { 0x00, 0x00 },
        { 0x00, 0x7C },
        { 0x71, 0x8A },
        { 0x00, 0x84 },
        { 0xB5, 0x61 },
        { 0x00, 0x7A },
        { 0x29, 0x1C },
        { 0x00, 0x7A },
        { 0xC4, 0xDE },
        { 0x00, 0x88 },
        { 0x59, 0xD8 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 65 (0x41)
    { 0x00, 0x41 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x3F, 0xFD },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0xE0 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x7F, 0xFF },
        { 0x00, 0x08 },
        { 0x46, 0x34 },
        { 0x00, 0xF8 },
        { 0x08, 0x2F },
        { 0x00, 0x07 },
        { 0xAF, 0x06 },
        { 0x00, 0x7F },
        { 0x92, 0x09 },
        { 0x00, 0x80 },
        { 0xD6, 0x54 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x03 },
        { 0x9C, 0x65 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x80 },
        { 0x6D, 0xF8 },
        { 0x00, 0x7F },
        { 0x29, 0xAB },
        { 0x00, 0x7B },
        { 0x43, 0x5A },
        { 0x00, 0x89 },
        { 0x22, 0xB1 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x00 },
// page 66 (0x42)
    { 0x00, 0x42 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x7E },
        { 0x39, 0x00 },
        { 0x00, 0x83 },
        { 0x81, 0x89 },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x00 },
        { 0x03, 0x1E },
        { 0x00, 0x7E },
        { 0x39, 0x00 },
        { 0x00, 0x83 },
        { 0x81, 0x89 },
        { 0x00, 0x1E },
        { 0xF0, 0x7E },
        { 0x00, 0x7E },
        { 0x3C, 0x1E },
        { 0x00, 0x81 },
        { 0xC3, 0xE2 },
        { 0x00, 0x7E },
        { 0x3C, 0x1E },
        { 0x00, 0x7E },
        { 0x39, 0x00 },
        { 0x00, 0x83 },
        { 0x81, 0x89 },
        { 0x00, 0x7E },
        { 0x3C, 0x1E },
        { 0x00, 0x81 },
        { 0xC3, 0xE2 },
        { 0x00, 0x7E },
        { 0x3C, 0x1E },
        { 0x00, 0x7E },
        { 0x39, 0x00 },
        { 0x00, 0x83 },
        { 0x81, 0x89 },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x71 },
        { 0x34, 0xCC },
        { 0x00, 0x8E },
        { 0xCB, 0x34 },
        { 0x00, 0x71 },
        { 0x34, 0xCC },
        { 0x00, 0x70 },
        { 0xB8, 0xC0 },
        { 0x00, 0x9C },
        { 0x9E, 0x50 },
        { 0x00, 0x74 },
        { 0xB3, 0xDC },
        { 0x00, 0x8B },
        { 0x4C, 0x24 },
        { 0x00, 0x74 },
        { 0xB3, 0xDC },
        { 0x00, 0x74 },
        { 0x33, 0xFB },
        { 0x00, 0x95 },
        { 0x98, 0x85 },
        { 0x00, 0x00 },
// page 67 (0x43)
    { 0x00, 0x43 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0x3D, 0xF6 },
        { 0x00, 0x81 },
        { 0x2F, 0x59 },
        { 0x00, 0x7E },
        { 0x68, 0xE7 },
        { 0x00, 0x7E },
        { 0xD0, 0xA7 },
        { 0x00, 0x82 },
        { 0x59, 0x22 },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0xFF },
        { 0x80, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 68 (0x44)
    { 0x00, 0x44 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 69 (0x45)
    { 0x00, 0x45 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x04 },
        { 0x02, 0x30 },
        { 0x00, 0xEB },
        { 0x53, 0xCD },
        { 0x00, 0x3F },
        { 0x1F, 0x1E },
        { 0x00, 0x43 },
        { 0x00, 0x00 },
        { 0x00, 0x03 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x8E },
        { 0x7A, 0x54 },
        { 0x00, 0x76 },
        { 0xC3, 0xB6 },
        { 0x00, 0xBD },
        { 0x33, 0x8F },
        { 0x00, 0x20 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x7B, 0xA7 },
        { 0x00, 0x00 },
        { 0x7B, 0xA7 },
        { 0x00, 0x00 },
        { 0x7B, 0xA7 },
        { 0x00, 0x70 },
        { 0x46, 0x2B },
        { 0x00, 0x9D },
        { 0x85, 0x0E },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
// page 70 (0x46)
    { 0x00, 0x46 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x0F },
        { 0x99, 0x4B },
        { 0x00, 0x5A },
        { 0x87, 0x2B },
        { 0x00, 0x2D },
        { 0x41, 0x3D },
        { 0x00, 0x5A },
        { 0x82, 0x7A },
        { 0x00, 0x02 },
        { 0x1C, 0xBC },
        { 0x00, 0xF8 },
        { 0x00, 0x00 },
        { 0x00, 0xFF },
        { 0x80, 0x00 },
        { 0x00, 0xFE },
        { 0x00, 0x00 },
        { 0x00, 0x64 },
        { 0x87, 0xED },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x47 },
        { 0xC0, 0x00 },
        { 0x00, 0x5A },
        { 0xC0, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0xFF },
        { 0xFF, 0xFF },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x40 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x7F },
        { 0xFF, 0xFF },
        { 0x00, 0x08 },
        { 0x00, 0x00 },
        { 0x00, 0xC0 },
        { 0x00, 0x00 },
        { 0x00, 0x80 },
        { 0x00, 0x00 },
        { 0x00, 0x0B },
        { 0xC0, 0x00 },
        { 0x00, 0x29 },
        { 0x80, 0x00 },
        { 0x00, 0x00 },
        { 0x06, 0xD3 },
        { 0x00, 0x7F },
        { 0xF9, 0x2D },
        { 0x00, 0x00 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Smart Amp Mode
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Smart Amp Mode
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// DSP Program = miniDSP
    { 0x2B, 0x1F },
// Digital Volume Control = 0dB
    { 0x3D, 0x30 },
    { 0x3E, 0x30 },
// Select Page 44
    { 0x00, 0x2C },
// Disable miniDSP_D Adaptive Mode
    { 0x01, 0x00 },
// Enable miniDSP_D Adaptive Mode
    { 0x01, 0x04 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Config
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Post-configuration
//-------------------------------------------------
// Select Page 1
    { 0x00, 0x01 },
// Charge Pump Delay = 165ns
    { 0x03, 0x04 },
// Select Page 0
    { 0x00, 0x00 },
// PLL reference clock = BCK (no SCK present)
    { 0x0D, 0x10 },
// Ignore SCK halt detection (no SCK present)
    { 0x25, 0x08 },
// Fast BG ramp-up
    { 0x08, 0x10 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Wake
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Wake
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// Wake from Standby
    { 0x02, 0x00 },
// Unmute L/R
    { 0x03, 0x00 },
};
